package gov.va.med.framework.conversion.converter;

import gov.va.med.domain.persistence.jdbc.helper.DestinationEntry;
import gov.va.med.mhv.rxrefill.data.model.Destination;
import gov.va.med.mhv.rxrefill.data.model.Institutions;
import gov.va.med.mhv.rxrefill.exception.MHVRuntimeException;

import java.util.Date;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class DestinationConverter {
	
    private static Logger logger = LogManager.getLogger(DestinationConverter.class);
    
	public DestinationEntry convert(Destination source) {
		DestinationEntry destination = new DestinationEntry();
		destination.setDestinationId(source.getId());
		destination.setInstitutionId(source.getInstitutionId());
		destination.setOtherDestinationName(source.getOtherDestinationName());
		destination.setVersion(source.getMhvVersion());
		destination.setParticipating(source.getParticipating());

		if(destination.getOtherDestinationName() == null) {
			Institutions institution = source.getInstitution();
			if (institution == null) {
			    String message = "Destination Load failed for institution id[" +  
			    				 destination.getInstitutionId()+ "] and Destination key ["+ 
			    				 destination.getDestinationId() + "]. Check the configuration.";
			    logger.error(message);
				throw new MHVRuntimeException("Unable to load destination for an unknown institution id. Check the configuration.");
			} else {
				destination.setActive(isActiveYN(institution, source.getActive()));
				destination.setStationNumber(institution.getStationNumber());
				destination.setVistaName(institution.getVistaName());
				destination.setName(institution.getName());
			}
		}

		return destination;
	}
	/** 
	 * Returns the defaultvalue if the deactivation date does not 
	 * force an override to "N".  
	 *  
	 * @param institution
	 * @param defaultValue the Active flag from the DESTINATIONS database 
	 */
	private String isActiveYN(Institutions institution, String defaultValue) {

	    if (institution.getDeactivationDate() == null) {
	        return defaultValue;
	    }
	    
	    // if deactivation in the past, it is inactive
	    if ( new Date().getTime() - institution.getDeactivationDate().getTime() >= 0) {
	        return "N";
	    }
	    return defaultValue; 
	}
} 
